
'Data logger with selectable CPU speed and CPU sleep function to reduce average power consumption if required
option autorun on

rtc gettime
dim filedate$,filename$,filenamept1$,filenamept2$,ext$,space$,hrzero$,minute_zero$,cpu_sleep$
dim data_value,Scale_factor,Scale_factor_value,sample_time,sample_time_inc,noise_reduction_value,noise,temp_value
dim analog_pin_in,sample_time_pin,sample_time_value,sample_time_factor,led_indicator_pin,sleep_time,cpu_sleep_flag,cpu_speed_flag,cpu_speed,minute_flag
dim float temp,humidity
dim integer humidity_pin

          'assign pins and variables

Scale_factor_value=6          'used to scale analog input on pin 18 eg value of 6 equates to max input of approximately 18 Volts

sample_time_factor=1.55       'used to scale sample time analog value close to whole numbers

noise_reduction_value=16     'Used for input signal averaging to reduce sampling noise
  
humidity_pin=32              '5v pin used for temperature and humidity readings

setpin 22,din                'CPU speed flag input
setpin 30,din                'CPU sleep flag input
setpin 18,ain               'analog input pin max 3.3V
setpin 21,ain               'sample time selection pin 0-3.3V in 0.66V steps
setpin 31,dout              'led indicator pin

cpu_speed_flag=pin(22)
cpu_sleep_flag=pin(30)
led_indicator_pin=31
sample_time_pin=21
analog_pin_in=18
pin (led_indicator_pin)=0
sample_time_value=0
sample_time_inc=0
sleep_time=1
minute_flag=0
data_value=0
temp_value=0

Scale_factor=Scale_factor_value      'Scales analog input on pin 18 for I/P of 0v to 18V multiplier value is 6 as I/P attenuation is 6
minute_zero$="00"                     
ext$=".txt"
filenamept1$="Data "
space$=" "
hrzero$="00Hr"

if cpu_speed_flag=1 then       'Test for CPU speed setting via pin 22
cpu 100                        'Running current 80ma, sleep current between samples 7ma
cpu_speed=100                  'Variable to print to terminal for testing
else
cpu 30                        'Running current 40ma, sleep current between samples 7ma
cpu_speed=30
endif

if cpu_sleep_flag=1 then      'Test for CPU sleep setting via pin 30
cpu_sleep$="Disabled"         'Variable to print to terminal for testing
else
cpu_sleep$="Enabled"
endif

        'Get averaged analog input value of sample time pin eg pin 21 based on link setting

for noise = 1 to noise_reduction_value
temp_value=pin(sample_time_pin)
data_value=data_value+temp_value
next noise

data_value=data_value/noise_reduction_value     'data_value now contains averaged sample time analog input
data_value=data_value*sample_time_factor        'used to scale sample time analog value close to whole numbers
sample_time_value=fix(data_value)               'produce true integer value of 0 1 2 3 4 5 to set sample times as 2 6 10 15 30 or 60 seconds

        'test of analog pin 21 ie data_value done here to determine the sample time and sleep time, if enabled based on link position
select case sample_time_value
  case 0
    sample_time=2:sleep_time=1
  case 1
    sample_time=6:sleep_time=4
  case 2
    sample_time=10:sleep_time=7
  case 3
    sample_time=15:sleep_time=10
  case 4
    sample_time=30:sleep_time=20
  case 5
    sample_time=60:sleep_time=45:minute_flag=1
  case else
    sample_time=2:sleep_time=1
end select

pin (led_indicator_pin)=1                   'Indicator LED on until start of minute then logging starts

                                              'print values to terminal
  print "sample time data value  ",data_value/sample_time_factor," Volts"
  print "sample time Integer value ",sample_time_value
  print "sample_time  ",sample_time," Seconds"
  print "CPU Speed ",cpu_speed," Mhz"
  print "CPU Sleep ",cpu_sleep$
  print
  humid humidity_pin,temp,humidity              'Poll sensor
  pause 2000                                    'Delay to stabilise sensor for first reading
  humid humidity_pin,temp,humidity
  print "Temperature ",temp,"C","  Humidity ",humidity,"%"


do
loop until right$(time$,2)=minute_zero$
pin(led_indicator_pin)=0
filenamept2$=left$(time$,2)                 'Prepare file name part2 hour value

do                                          'Main program here

if left$(time$,2) = filenamept2$ then       'Current hour? yes continue, if not get new Pt2 name

filename$=date$+space$+filenamept1$+filenamept2$+hrzero$+ext$       'Build file name eg 01-07-2018 Data 1400Hr.txt
data_value=0                                        'Clear variable
temp_value=0                                        'Clear variable
pin (led_indicator_pin)=1                           'Indicator LED on during data save, results in a short pulse

                                                   'Open file for append
open filename$ for append as #2

for noise = 1 to noise_reduction_value              'Get data, average/filter and save to SD card
temp_value=pin(analog_pin_in)*Scale_factor
data_value=data_value+temp_value
next noise

data_value=data_value/noise_reduction_value
humid humidity_pin,temp,humidity
print #2,date$,time$,data_value,temp,humidity
close #2
pin (led_indicator_pin)=0                           'turn off indicator LED and then print data to terminal

print "Data Value on input ",data_value," Volts","   Temperature ",temp,"c   Humidity ",humidity,"%"
                    'Following section syncs to next sample interval or end of minute, puts CPU to sleep if enabled and checks for new hourly data file
sample_time_inc=sample_time_inc+sample_time
if sample_time_inc=60 then

if minute_flag=1 then
sample_time_inc=0
pause 1000
endif
sample_time_inc=0
else
endif
if cpu_sleep_flag=0 then              'If enabled put CPU to sleep for approx 75% of sample time
cpu sleep sleep_time
pause 150                             'Pause to settle system after sleep
endif
rtc gettime
do

loop until val(right$(time$,2))=sample_time_inc

else
rtc gettime
filenamept2$=left$(time$,2)           'New hourly data file name Pt2

do
loop until right$(time$,2)=minute_zero$   'Sync to new minute
sample_time_inc=0
endif

loop
end
